// LZAri.hpp - Header file for the decompression code
// Noose 25/5/98

#ifndef DECARI_HPP
#define DECARI_HPP

#define N		 4096	// Size of ring buffer 
#define F		   60	// Upper limit for match_length 
#define THRESHOLD	2   // Encode string into position and length
						//  if match_length is greater than this 
#define NIL			N	// Index for root of binary search trees

#define M          15

#define TRUE        1
#define FALSE       0

#define MAX_LINE_LEN 256 // Length of longest line to appear in the source
                        // This must be set to a sufficiently high number to
                        // prevent buffer overlap in the cyclical buffer
                        // otherwise you'll lose the ends of lines

/*	Q1 (= 2 to the M) must be sufficiently large, but not so
	large as the unsigned long 4 * Q1 * (Q1 - 1) overflows.  */

#define Q1  (1UL << M)
#define Q2  (2 * Q1)
#define Q3  (3 * Q1)
#define Q4  (4 * Q1)
#define MAX_CUM (Q1 - 1)

#define N_CHAR  (256 - THRESHOLD + F)
	/* character code = 0, 1, ..., N_CHAR - 1 */

#define MAX_READ_BUFF MAX_LINE_LEN+THRESHOLD
                                    // This should suffice for cyclical buffer
                                    // If too low then end of lines will be chopped

class LZAri {
    unsigned char   text_buf[N + F - 1];	
    int		        match_position, match_length;
	int	            lson[N + 1], rson[N + 257], dad[N + 1];

    FILE            *infile,*outfile;

    unsigned long   textsize, codesize, printcount,Step;

    unsigned long   low, high, value;
    int             shifts;  // counts for magnifying low and high around Q2
    int             char_to_sym[N_CHAR], sym_to_char[N_CHAR + 1];
    unsigned int    sym_freq[N_CHAR + 1],  // frequency for symbols
	                sym_cum[N_CHAR + 1],   // cumulative freq for symbols
	                position_cum[N + 1];   // cumulative freq for positions

    int             GetBit(void);
    void            StartModel(void);
    void            UpdateModel(int sym);
    void            StartDecode(void);
    int             DecodeChar(void);
    int             DecodePosition(void);
    int             BinarySearchSym(unsigned int x);
    int             BinarySearchPos(unsigned int x);

    void            PutBit(int bit);
    void            FlushBitBuffer(void);
    void            InitTree(void);
    void            InsertNode(int r);
    void            DeleteNode(int p);
    void            Output(int bit);
    void            EncodeChar(int ch);
    void            EncodePosition(int position);
    void            EncodeEnd(void);
    char            GetChar(void);

    void            Decode(void);
    void            Encode(void);

    int				UpdateProgress(void);

	unsigned long   count,Counter;            // Current Offset in file
	int             j, k, r;
    char            ReadBuffer[MAX_READ_BUFF+1]; // Cyclical Read Buffer
    int             RBOffset;               // Offset in ReadBuffer
    int             RBLineStart;            // Start of current line in buffer

    char            *OutputBuffer;

    void            PutChar(int c);         // Add a character to the read buffer
    int             _eofFlag;
    unsigned int    charbuffer, umask;      // Used by GetBit

    int             CompleteBuffer(int*,int*,char*);
public:
                    LZAri(char *fn,char *Buffer);
                   ~LZAri();
    void            Readln(char *Buffer);
    int             eof(void);
};

#endif
